package com.qboxus.tictic.activitesfragments.shoping.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.shoping.models.ProductModel
import com.qboxus.tictic.databinding.ItemProfileProductsLayoutBinding
import com.qboxus.tictic.interfaces.AdapterClickListener
import com.qboxus.tictic.simpleclasses.Functions.frescoImageLoad
import com.qboxus.tictic.simpleclasses.Functions.getProductPrice

class ProfileProductsAdapter(
    var context: Context,
    productModels: ArrayList<ProductModel>,
    adapterClickListener: AdapterClickListener
) : RecyclerView.Adapter<ProfileProductsAdapter.MyViewholder>() {
    var datalist: ArrayList<ProductModel> = ArrayList()
    var adapterClickListener: AdapterClickListener

    init {
        this.datalist = productModels
        this.adapterClickListener = adapterClickListener
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MyViewholder {
        val binding = DataBindingUtil.inflate<ItemProfileProductsLayoutBinding>(
            LayoutInflater.from(parent.context),
            R.layout.item_profile_products_layout,
            parent,
            false
        )
        return MyViewholder(binding)
    }

    override fun onBindViewHolder(holder: MyViewholder, position: Int) {
        val productModel = datalist[position]
        if (productModel.productImage.size > 0) {
            holder.binding.productImage.controller =
                frescoImageLoad(
                    productModel.productImage[0].image,
                    holder.binding.productImage,
                    false
                )
        }
        holder.binding.productName.text = productModel.product.title
        holder.binding.productDiscription.text = productModel.product.description

        holder.binding.productPrice.text =
            Constants.productShowingCurrency + getProductPrice(
                productModel
            )

        holder.bind(position, productModel, adapterClickListener)
    }

    override fun getItemCount(): Int {
        return datalist.size
    }

    inner class MyViewholder(var binding: ItemProfileProductsLayoutBinding) :
        RecyclerView.ViewHolder(
            binding.root
        ) {
        fun bind(position: Int, item: ProductModel?, listener: AdapterClickListener) {
            binding.shopItem.setOnClickListener { v: View? ->
                listener.onItemClick(v, position, item)
            }
        }
    }
}
